import numpy as np
import fitsio
import wavelet
import matplotlib.pyplot as mplt


def dosmooth(im):
    from scipy.ndimage import gaussian_filter
    return gaussian_filter(im, sigma=200)


def get_sep_background(im, width=128):
    import sep

    # force c contig
    use_im = np.array(im, dtype='f4')
    return sep.Background(use_im, bw=width, bh=width)


def main():
    bkg_width = 128

    im = fitsio.read('coadd_drc.fits')

    sim = im[2300:4000, 400:4000]
    back = get_sep_background(sim, width=bkg_width)
    # sim = sim - np.nanmedian(sim)
    sim = sim - back.globalback

    # smooth = dosmooth(sim)

    st = wavelet.starlet_transform(sim, generation=1)

    scale = 0.005
    cmap = 'inferno'
    with mplt.style.context('dark_background'):
        fig, axs = mplt.subplots(
            nrows=3, ncols=2,
            # figsize=(16, 10),
            figsize=(16, 16),
            layout='tight',
        )

        axs[0, 0].set_title('image')
        # axs[0, 1].set_title('smoothed')
        axs[0, 1].set_title(f'sep background {bkg_width}x{bkg_width}')
        axs[1, 0].set_title('starlet 9')
        axs[1, 1].set_title('starlet 8')
        axs[2, 0].set_title('starlet 7')
        axs[2, 1].set_title('starlet 6')

        axs[0, 0].imshow(np.asinh(sim / scale), cmap=cmap)

        # axs[1].imshow(st[9], cmap=cmap)
        # axs[2].imshow(st[8], cmap=cmap)
        # axs[0, 1].imshow(np.asinh(smooth / scale), cmap=cmap)
        axs[0, 1].imshow(back.back(), cmap=cmap)
        axs[1, 0].imshow(np.asinh(st[9] / scale), cmap=cmap)
        axs[1, 1].imshow(np.asinh(st[8] / scale), cmap=cmap)
        axs[2, 0].imshow(np.asinh(st[7] / scale), cmap=cmap)
        axs[2, 1].imshow(np.asinh(st[6] / scale), cmap=cmap)

        fig.savefig('starlets-and-bkg.pdf')
        # mplt.show()


main()
